require( "scripts/style.lua" );


IntroFont = {
  standardFont,
  24,
  BorderColor
};

BottomStatFont = {
  standardFont,
  18,
  BorderColor
};

StatFont = {
  standardFont,
  14,
  BorderColor
};

LevelFont = {
  standardFont,
  24,
  RedColor
};

InfoFont = {
  standardFont,
  18,
  BorderColor
};

HighScoreFont = {
  standardFont,
  18,
  BorderColor
};

ExpertFont = {
  standardFont,
  20,
  BlackColor
};

kTextY = 138;
kNumY = 148;
kBoxWidth = 100;


MakeDialog
{
		
	LevelOver
	{
		x=0,
		y=0,
		w=800,
		h=600,
		name="leveloverwin",
		
		Window
		{
			-- this bitmap doesn't really exist, i'm just using it as a group
			x=0,y=0,w=kMax,h=kMax,
			image="doesnotexist",
			name="overbackground",
			Bitmap
			{
				name="backgroundimage",
				image="backgrounds/levelover",
				x=250,
				y=92,
				w=kMax,
				h=kMax,
				
				
				Text
				{
					font = StatFont,
					name = "tablesserved",
					x=40,y= kTextY,w=kBoxWidth ,h=50,
					flags = kHAlignCenter + kVAlignTop,
					label = "tablesserved"
				};
				
				Text
				{
					font = IntroFont,
					name = "served",
					x=40,y= kNumY,w=kBoxWidth ,h=32,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				Text
				{
					font = StatFont,
					name = "tableslost",
					x=127,y= kTextY,w=kBoxWidth ,h=50,
					flags = kHAlignCenter + kVAlignTop,
					label = "tableslost"
				};
				
				Text
				{
					font = IntroFont,
					name = "lost",
					x=127,y= kNumY,w=kBoxWidth ,h=32,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				Text
				{
					font = StatFont,
					name = "levelstr",
					x=210,y= kTextY,w=kBoxWidth ,h=50,
					flags = kHAlignCenter + kVAlignTop,
					label = "level_lower"
				};
				
				Text
				{
					font = LevelFont,
					name = "level",
					x=210,y= kNumY,w=kBoxWidth ,h=32,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				Text
				{
					font = InfoFont,
					name = "levelinfo",
					x=70,y=183,w=195,h=200,
					flags = kHAlignLeft + kVAlignTop,
					label = "0"
				};
				
				
				Text
				{
					font = BottomStatFont,
					name = "levelscorestr",
					x=70,y= 390,w=155 ,h=25,
					flags = kHAlignLeft + kVAlignTop,
					label = "levelscore"
				};
				
				Text
				{
					font = BottomStatFont,
					name = "levelscore",
					x=170,y= 390,w=92 ,h=25,
					flags = kHAlignRight + kVAlignTop,
					label = "0"
				};
				
				Text
				{
					font = BottomStatFont,
					name = "totalscore",
					x=90,y= 415,w=155 ,h=29,
					flags = kHAlignLeft + kVAlignTop,
					label = "totalscore"
				};
				
				Text
				{
					font = BottomStatFont,
					name = "score",
					x=132,y= 415,w=130 ,h=29,
					flags = kHAlignRight + kVAlignTop,
					label = "0"
				};
				
				Text
				{
					font = HighScoreFont,
					name = "highscoretext",
					x=68,y=270,w=190,h=163,
					flags = kHAlignLeft+ kVAlignTop,
					label = "newhighscore",
				};
				
				SetStyle(SmallestButtonStyle);
				Button
				{
					x=110,
					y=367,
					name="highscorebutton",
					label="highscores",
					type = kPush,
					command=
							function()
								CloseAllWindows();
								DoModal("scripts/hiscore.lua");
							end
				},
				
				SetStyle(SmallestButtonStyle);
				Button
				{
					x=90,
					y=430,
					name="quit",
					label="quit",
					type = kPush,
					command=
							function()
								QuitGame(false);
								PopModal("scripts/game.lua");
							end
				},
				
				Button
				{
					x=180,
					y=430,
					name="tryagain",
					label="tryagain",
					type = kPush,
					command=
							function()
								RestartLevel();
							end
				},
				
				SetStyle(SmallestButtonStyle);
				Button
				{
					x=120,
					y=432,
					name="continue",
					label="continue",
					type = kPush,
					flags = kHAlignCenter + kVAlignCenter, 
					command=
							function()
								if (GetUnlockedNewExpert()) then
									DoModal("scripts/unlocked.lua");
								end
								GoToNextLevel();
							end
				},
				
				SetStyle(DefaultStyle);
				
				
				
			},
			
			Bitmap
			{
				name="expert",
				image="ui/expert",
				x=498,
				y=34,
				
				Text
				{
					name="experttext",
					label="expert_badge",
					x = 25, y = 27,
					w = 90, h = 100,
					flags = kHAlignCenter + kVAlignCenter,
					font = ExpertFont,
					rotation = - 11,
				},
			},
			
			Bitmap
			{
				name="flowin",
				image="backgrounds/flo_win",
				x=20,
				y=0,
			},
			
			Bitmap
			{
				name="flolose",
				image="backgrounds/flo_lose",
				x=130,
				y=0,
			},
		},
		
	},
	
}
